# Copyright (C) 2021 Nippon Telegraph and Telephone Corporation
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from tacker.sol_refactored.objects import base
from tacker.sol_refactored.objects import fields


# NFV-SOL 003
# - v3.3.1 4.4.1.12
@base.TackerObjectRegistry.register
class ExtManagedVirtualLinkData(base.TackerObject,
                                base.TackerObjectDictCompat):

    # Version 1.0: Initial version
    VERSION = '1.0'

    fields = {
        'id': fields.StringField(nullable=False),
        'vnfVirtualLinkDescId': fields.StringField(nullable=False),
        'vimConnectionId': fields.StringField(nullable=True),
        'resourceProviderId': fields.StringField(nullable=True),
        'resourceId': fields.StringField(nullable=False),
        # NOTE: this should be corrected in a future SOL release.
        'vnfLinkPort': fields.ListOfObjectsField(
            'VnfLinkPortDataV2', nullable=True),
        'extManagedMultisiteVirtualLinkId': fields.StringField(
            nullable=True),
    }
